
/**
 ******************************************************************************
 *
 * @file        main.c
 *
 * @brief       This is the C code is main code.
 *
 * @par         Project
 *              Smart Card
 * @version     V1.00
 * @date        2022/11/23
 * @author      Megawin Software Center
 * @copyright   Copyright (c) 2017 MegaWin Technology Co., Ltd.
 *              All rights reserved.
 *
 ******************************************************************************
 * @par 		Disclaimer 
 *		The Demo software is provided "AS IS"  without any warranty, either 
 *		expressed or implied, including, but not limited to, the implied warranties 
 *		of merchantability and fitness for a particular purpose.  The author will 
 *		not be liable for any special, incidental, consequential or indirect 
 *		damages due to loss of data or any other reason. 
 *		These statements agree with the world wide and local dictated laws about 
 *		authorship and violence against these laws. 
 ******************************************************************************
 ******************************************************************************
 */ 

/* Includes ------------------------------------------------------------------*/
#include "MG32x02z_DRV.h"
#include "MG32x02z_CSC_Init.h"
#include "MG32x02z_GPIO_LQFP80U_Init.h"
#include "MG32x02z_Common.h"
#include "MG32x02z_SmartCard_API.h"
#include "MG32x02z_SPILCD_API.h"
#include "MG32x02z_LCD.h"


/* Wizard menu ---------------------------------------------------------------*/
/* Private typedef -----------------------------------------------------------*/
/* Private define ------------------------------------------------------------*/
/* Private macro -------------------------------------------------------------*/
/* Private variables ---------------------------------------------------------*/
/* Private function prototypes -----------------------------------------------*/
void SysTick_Handler(void);

static void MG32x02z_Init(void);



/* Exported variables --------------------------------------------------------*/
/* Exported functions --------------------------------------------------------*/
/* External variables --------------------------------------------------------*/


/**
 *******************************************************************************
 * @brief	    main function
 * @details     
 * @return      
 * @exception   No
 * @note        1. The sample project only support ISO/IEC 7816-3 
                   interfac device ATR part.
                2. The sample only one class no support multi-class.
 *******************************************************************************
 */
int main(void)
{
    /*MG32F02U128 initial*/
    MG32x02z_Init();
    

    while(1)
    {
        //The code only receive ATR
        API_SmartCard_main();
        
        //Show card status and ATR receive result. 
        MG32x02z_LCD_main();  
    }
}


/**
 *******************************************************************************
 * @brief	    Systick interrupt handler 
 * @details     MG04-06 project time base (1ms)
 * @return      
 * @exception   No
 * @note
 *******************************************************************************
 */
void SysTick_Handler(void)
{
    API_IncTick(); 
    
}


/**
 *******************************************************************************
 * @brief	    The project initial.
 * @details     
 * @return      
 * @exception   No
 * @note
 *******************************************************************************
 */
static void MG32x02z_Init(void)
{
    /*IC hardware initial (ChipInit_Wizard)*/
    UnProtectModuleReg(MEMprotect);
    MEM->CR0.MBIT.FWAIT  = 1;
    MEM->CR0.MBIT.HSP_EN = 1;
    ProtectModuleReg(MEMprotect);
    /*
    CSC Initial:
     1. PLLO    = 48MHz
     1. CK_MAIN = PLLO (48MHz)
     2. CK_APB  = PLLO / 1 (48MHz)
     3. CK_AHB  = CK_APB / 2 (24MHz)
    */
    CSC_Init();
    
    /*The GPIO initial is for MG32x02z_GPIO_LQFP80U_Init.h*/
    GPIO_Init();
    
    /* Use systick as time base source and configure 1ms tick (default clock after Reset is HSI) */
    API_InitTick(0);
    
    /*DMA initial*/
    DMA_Init();
    
    /*UART Connector-0 Initial*/
    API_UARTConnector0_Init();

    /*LCD related initial*/
    API_LCD_Init();     
    
    /*SMC related peripherals initial*/
    API_SmartCard_Init();
              
}
/**
 * @name Smart Card Releated.
 *             
 */ 
///@{

/**
 *******************************************************************************
 * @brief	    Smart card remove callback function.
 * @details     
 * @return      
 * @exception   No
 * @note
 *******************************************************************************
 */
void API_SmartCard_CardRemoveCallback(void)
{
    LCD_Refresh = 1;
}


/**
 *******************************************************************************
 * @brief	    Smart card ATR receive complete callback function.
 * @details     
 * @return      
 * @exception   No
 * @note        
 *******************************************************************************
 */
void API_SmartCard_ATRCpltCallback(void)
{
    LCD_RefreshDataType = LCD_REFRESH_DATATYPE_ATR;
    LCD_Refresh         = 1;
}

/**
 *******************************************************************************
 * @brief	    Smart card error callback function.
 * @details     
 * @return      
 * @exception   No
 * @note        
 *******************************************************************************
 */
void API_SmartCard_ErrorCallback(void)
{
    LCD_RefreshErrorStatus = (SmartCard_CTR.Status.W & SmartCard_STATUS_ERROR);
    LCD_RefreshDataType    = LCD_REFRESH_DATATYPE_ERR;
    LCD_Refresh            = 1;
}


/**
 *******************************************************************************
 * @brief	    Smart card error callback function.
 * @details     
 * @return      
 * @exception   No
 * @note        
 *******************************************************************************
 */
void API_SmartCard_CardInsertCallback(void)
{
    LCD_RefreshErrorStatus = 0;
}

///@}







